# 第四章 中国开源社区发展现状

当前我们所身处的数字化时代几乎都是由开源代码所构建的，伴随着开源运动在中国的落地与发展，中国的开源社区从最初单一且独立的社区不断演进，呈现出今天百花齐放的繁荣景象。本篇集中呈现当前国内各类社区发展的现状和特点。

## 4.1 中国开源社区的起源与发展历程

十几年前，很多人认为“开源=Linux”，因为当时的Linux操作系统、桌面办公软件（GNOME、OpenOffice）和浏览器（Mozilla）作为开源项目的主战场，掀起了第一波开源的浪潮。随着开源项目规模的不断壮大，开源社区也逐渐形成。

国内的开源社区起初以Linux爱好者为主导，最早出现于1998年。不过，早期国内社区多为个人爱好者兴办，社区的发展规模和影响力有很大的局限性，因此中国第一代社区的持续发展能力不足，大多销声匿迹。如，于1998年在清华大学成立的阿卡社区（AKA），2000年前后发展到顶峰，但此后受骨干成员出国、成家、创业等影响，逐渐进入低潮期，其中部分人员转型嵌入式培训，AKA转变为亚嵌公司。AKA早期的多数成员后来成为了中国最早的一批Linux精英。2001年创立的灰狐动力社区，最初只是一个关于中间件技术研究和应用纯个人网站，到2002年已经成为国内中间件行业极具权威性的站点。但在2010年5月19日，灰狐动力和开源力量宣布合并。创始于2006年12月的哲思社区，在当时是中国知名的自由软件社区，也已于多年前停更。而其中只有少数幸运的优秀社区因得到企业和产业的广泛认可而找到生存模式获得新生，如CSDN逐渐成长为中国最大开发者社区，ChinaUnix社区被IT168公司收购，PHPChina社区被康盛创想公司收购（后期被腾讯整体收购），开源中国社区被恒拓开源公司收购等。
    
后来，随着互联网的兴起，开源的项目和技术呈现百花齐放之盛况，从数据库到中间件、从前端到后端、从编程语言到编译器、从物联网到微服务、从大数据到人工智能，开源的技术和项目越来越丰富和多样化。在此趋势下，自2008年起，中国第二代开源社区纷纷登场。在吸取了一代的教训后，第二代社区的典型特征是更加聚焦、更加务实，通常是围绕一个公司的特定产品，且该公司作为社区的唯一或最大赞助商。这类社区包括深度操作系统社区、Ubuntu麒麟社区、龙芯俱乐部、OpenEuler社区等。这些社区的发起团队普遍具有全球开源视野，同时也认识到知名科技企业在开源生态发展中的核心作用，与企业合作共赢是开源社区发展的关键路径，第二代社区开始有意识地吸纳开源布道者、市场专业人士和法律专业人士成为社区的骨干人员。
    
近几年，随着移动互联网和云计算、AI在中国的蓬勃发展，中国开始涌现出大量开源项目的开发者，国内开源社区进入第三代。典型代表包括开放原子开源基金会、开源中国社区、木兰开源社区、GitCode、确实（Trustie）开源社区、OpenI启智开源社区等。第三代社区的典型特征是在社区运营和管理上更加中立和平衡，且社区内包含不同来源的众多开源项目。目前中国第三代开源社区仍处于起步阶段，在开源治理、社区运营等方面尚显稚嫩。能够坚持中立立场、平衡诸多赞助商之间以及与开发者之间的关系，吸引开源治理专家、培养社区运营骨干是第三代社区当前面对的主要挑战。
    
中国第一代技术社区至今仍坚持运营的屈指可数，最成功的典范就是CSDN开发者社区，作为目前世界第二大的开发者社区，20多年来CSDN为中国培养了几代开源开发者，同时也见证了中国开源快速发展的20年。2022年4月，CSDN成为开放原子开源基金会黄金捐赠人。也通过扩大对开发者服务内容（开源知识库、培训、猎头、代码托管平台、开源项目孵化和开源创投），身体力行地推进开源产业的发展，正在积极地向第三代开源社区转型。

由企业主导的第二代社区正在积极的与第三代社区（含国际开源社区和开源基金会）合作，通过开源捐赠或发起新项目等多种形式融入第三代社区，如华为将欧拉开源操作系统（openEuler, 简称“欧拉”）捐赠给开放原子开源基金会，携程捐赠Apollo项目到Apollo开源社区，百度捐赠HugeGraph图数据库给Apache软件基金会，华为将开源的云原生多云容器编排项目Karmada捐赠给CNCF等。


## 4.2 中国开源社区的现状特征

据中国开源软件联盟不完全统计，截止2022年3月，国内各类开源社区已经超过500个，按照项目型社区、用户型社区和服务型社区三类进行汇总，项目型社区增速最为显著。

从开发者规模和开发者合作参与层次上，部分开源社区已经发展到非常大的规模，在社区生态上取得了显著的成绩。

### 4.2.1 项目型社区
    
项目型社区是聚焦特定开源项目，包括代码贡献和协作、集成测试、应用实践、用户反馈等核心功能，大部分项目型社区由背后的机构或企业来资助或直接运营。具有代表性的项目型社区见表14。

|社区名|领域|项目地址|项目社区介绍|
|-|-|-|-|
|openEuler社区|操作系统|https://www.openeuler.org|openEuler是由OpenAtom Foundation开发和运营的开源平台。其愿景是通过开放的社区形式与全球开发者共同构建一个开放、多元和架构包容的软件生态体系，孵化支持多种处理器架构、覆盖数字设施全场景，推动企业数字基础设施软硬件、应用生态繁荣发展。|
|OpenAnolis龙蜥社区|操作系统|https://openanolis.cn|OpenAnolis（龙蜥） 社区成立于2020年9月，是一个操作系统开源社区及创新平台，由国内、外领先操作系统、芯片、云计算公司共同发起，致力于通过开放的社区合作，构建国内自主Linux开源发行版及开源创新技术，推动软、硬件及应用生态繁荣发展。|
|OpenHarmony社区|操作系统|https://www.openharmony.cn|OpenHarmony是由开放原子开源基金会（OpenAtom Foundation）孵化及运营的开源项目，目标是面向全场景、全连接、全智能时代、基于开源的方式，搭建一个智能终端设备操作系统的框架和平台，促进万物互联产业的繁荣发展。|
|深度社区|操作系统|https://www.deepin.org|深度社区是由统信软件全资子公司武汉深之度科技于2008年发起，已经持续运营15年，以桌面操作系统为主的开源社区，也是国内规模最大、历史最悠久、活跃度最高的开源操作系统社区之一，深受全球开源爱好者喜爱，具备相当的国际影响力。|
|RT-thread社区|操作系统|https://www.rt-thread.org|RT-Thread是由上海睿赛德电子科技主导开发的开源实时操作系统，它也是集实时操作系统（RTOS）内核、中间件组件和开发者社区于一体的技术平台。
|Ubuntu Kylin社区|操作系统|https://www.ubuntukylin.com|优麒麟是由麒麟软件有限公司主导开发的全球开源项目。自创立以来已经有10年的历史以及技术沉淀，并得到了国际社区的认可。现累计发行20个操作系统版本，全球下载量3800+万次，活跃爱好者和开发者20+万人，累计向开源社区贡献代码超400万行，其中被Linux、GNOME、Unity、OpenStack、Ceph接收Patch超7400个。
|OceanBase社区|数据库|https://open.oceanbase.com|OceanBase社区版是一款开源分布式HTAP（Hybrid Transactional/Analytical Processing）数据库管理系统，具有原生分布式架构，支持金融级高可用、透明水平扩展、分布式事务、多租户和语法兼容等企业级特性。OceanBase内核通过大规模商用场景的考验，已服务众多行业客户，现面向未来持续构建内核技术竞争力。|
|TiDB社区|数据库|https://tidb.net|TiDB是PingCAP公司自主设计、研发的开源分布式关系型数据库，是一款同时支持在线事务处理与在线分析处理 (Hybrid Transactional and Analytical Processing, HTAP) 的融合型分布式数据库产品，具备水平扩容或者缩容、金融级高可用、实时HTAP、云原生的分布式数据库、兼容MySQL 5.7协议和MySQL生态等重要特性。|
|MongoDB中文社区|数据库|https://mongoing.com|MongoDB中文社区是围绕MongoDB生态建立的中文技术社区，获得MongoDB官方的认可和支持。社区关注MongoDB以及相关数据产品和工具。来自MongoDB官方的工程师、阿里腾讯等大型互联网公司及业界MongoDB专家、MongoDB书籍作者等组成社区核心成员|。
|TDengine社区|数据库|https://www.taosdata.com|TDengine是涛思数据开发的一款高性能、分布式、支持SQL的时序数据库，其核心代码包括集群功能全部开源，同时TDengine还带有内建的缓存、流式计算、数据订阅等系统功能，能大幅减少研发和运维的复杂度，可广泛应用于物联网、车联网、工业互联网、IT运维、金融等领域。|
|Apache Kylin|大数据|https://kylin.apache.org|Apache Kylin™是一个开源的、分布式的分析型数据仓库，提供Hadoop/Spark之上的SQL查询接口及多维分析（OLAP）能力以支持超大规模数据，它能在亚秒内查询巨大的表。|
|ClickHouse中文社区|大数据|http://www.clickhouse.com.cn|ClickHouse.com.cn社区为国内最专业最具影响力的ClickHouse开源技术社区，致力于ClickHouse 的技术研究、推广和普及。|
|Apache SkyWalking|云原生|https://skywalking.apache.org|SkyWalking是一款分布式系统的应用程序性能监控工具，专为微服务、云原生和基于容器 （Kubernetes） 的架构而设计。|
|飞桨PaddlePaddle社区|人工智能|https://www.paddlepaddle.org.cn|飞桨(PaddlePaddle)是百度开发的一款集深度学习核心框架、工具组件和服务平台为一体的技术先进、功能完备的开源深度学习平台，已被中国企业广泛使用，深度契合企业应用需求，拥有活跃的开发者社区生态。|
|华为MindSpore社区|人工智能|https://www.mindspore.cn/community|MindSpore是华为开源的自研AI框架。其希望通过社区合作，面向全场景构建最佳昇腾匹配、支持多处理器架构的开放AI框架，为算法工程师和数据科学家提供开发友好、运行高效、部署灵活的体验，帮助人工智能软硬件应用生态繁荣发展。|
|Apollo社区|汽车|https://developer.apollo.auto|Apollo开发者社区是百度致力于为全球自动驾驶开发者和合作伙伴提供的一个学习、交流的平台,助力开发者快速了解并使用自动驾驶技术。|
|超级账本中国技术工作组|区块链|https://github.com/Hyperledger-TWGC/Hyperledger-TWGC|超级账本中国技术工作组是由Hyperledger社区在2016年成立的第一个区域性工作组，主要负责培育中国的超级账本开发者社区。相关的开源实践工作包括但不限于研发与创新讨论，本地化与教育，合作和场景组织，活动组织，它是一个具备开源代码、项目孵化、开源治理、媒体等多种服务功能的社区。|

*表14 具有代表性的项目型社区*

### 4.2.2 用户型社区

用户型社区主要是开源爱好者自发形成的小型社区，以知识分享、经验交流和传播开源文化为主要目标。具有代表性的用户型社区见表15。

|社区名	|社区地址	|社区介绍|
|-|-|-|
|LinuxFans|http://www.linuxfans.org|LinuxFans社区成立于2002年，是一个专注于Linux及开源相关的技术社区及互助论坛，拥有社区发行版Magic Linux。|
|GoCN社区|https://gocn.vip|GoCN是中国最专业&最具影响力的Go技术社区。|
|Python中国社区	|https://pychina.org|PyChina是一个由全球使用中文的Python程序员自发组成的技术社区，面向实习、应用、推广Python以及相关技术的爱好者，关注Python语言在中国的应用、推广和学习。由Zoom.Quiet（大妈）和Sting Chen在2014年发起。它的前身是CPyUG（China Python User Group，华蟒用户组），发源于啄木鸟社区。|
|物联网自动化社区iot.cechina|http://iot.cechina.cn|物联网与自动化一脉相承，物联网自动化社区从工业控制和自动化的角度解读物联网产业的发展，分享最新动态、技术和应用。|
|Linux人社区 | |Linux人社区建立于2006年，是红旗Linux最辉煌时期的产物。Linux人社区不仅具有网论坛特性，它还拥有一个具有开发能力的社区团队。

*表15 具有代表性的用户型社区*

### 4.2.3 服务型社区

服务型社区平台是指具备开源代码、项目孵化、开源治理、媒体等多种服务功能的社区，其他垂直小众社区也在该社区平台构建自己的影响力。具有代表性的服务型社区如下。

**GitCode**（https://gitcode.net）

2020年9月，中国专业IT开发者社区CSDN推出全新升级的开源项目创新服务平台GitCode。作为独立的第三方开源社区，GitCode充分考虑了中国用户的使用习惯，也与GitHub形成了联动，在不久前发布了内测版MyGitHub，即GitHub精选，主要目的是让中国开发者针对项目文档等做一些中文介绍，以便让中国开发者更好地使用，并且这些内容将与CSDN的内容进行打通。

**Gitee**（https://gitee.com）

Gitee是OSCHINA推出的代码托管协作开发平台，支持Git和SVN，提供免费的私有仓库托管。2021年Gitee新增用户数超过了180万，达到800万。新增活跃的仓库数超过了200万，自2019年开始保持着大幅增长的趋势。

**鹏城汇智**（https://www.ihub.org.cn）

鹏城汇智平台是由鹏城实验室建立并运营的完全公益性的开源代码托管平台，主要聚焦于人工智能及RISC-V领域，旨在服务广大开发者及科研工作者群体，建设一个具有专业的代码托管功能、稳定易用的开源平台，展示国内外优质的开源项目，促进我国开源及人工智能领域的发展。

**GitLink**（https://www.gitlink.org.cn）

GitLink（确实开源）是CCF官方指定的开源创新服务平台，截至目前，已有5万开发者、1000+组织入驻，仓库数量累计140万。它为我国创新型软件产业发展提供了关键技术支撑和实践指南，支持了我国航空、航天、国防等多个关键领域的可信软件生产，为包括新一代人工智能启智社区、ARM绿色计算社区、云计算与大数据木兰社区、科技委可控开源创造行动红山社区等的建设提供关键技术支撑，为我国关键领域开源社区生态建设发挥了重要作用。

**Coding**（https://coding.net）

Coding是深圳市腾云扣钉科技有限公司推出的产品，其重点面向团队和企业的代码协作开发服务。Coding的项目管理包含任务、讨论、文件等功能，支持多成员协作，并且深度集成了代码仓库的操作与状态。

**木兰开源社区**（https://portal.mulanos.cn）

木兰开源社区建立于2019年8月，是国家重点研发计划重点专项“云计算和大数据开源社区生态系统”的成果之一，是一个为开发生活提供支撑的平台。旨在促进开源领域的交流，加强企业和行业用户之间的沟通，推进企业和个人开发者利用开源软件不断提升技术水平。从开源学习到商业代码托管，开发者可以从众多的云计算大数据开源开发项目中进行开发学习、主持和审查代码、管理项目和构建软件。

**OpenI启智**（https://www.openi.org.cn）

OpenI启智社区（Open Intelligence，简称启智社区）是在国家实施新一代人工智能发展战略背景下，新一代人工智能产业技术创新联盟（AITISA）组织产学研用通力协作共建共享的开源社区。面向新一代人工智能开源共性关键技术，OpenI将持续汇聚开源软件、开源硬件、开放数据等AI资源，构建OpenI技术链、创新链和生态链，旨在推动人工智能技术的健康快速发展及其在社会各个领域的广泛应用。

## 4.3 中国开源社区发展的挑战和趋势

社区是生态影响力的具体呈现。中国开源社区的发展阶段映射出开发者技术、开发者水平和在全球软件技术中的地位，虽然开发者规模庞大，但在基础领域原创性还远远不足。体现在中国开源社区中，主动贡献的开发者比例较少，社区主要面向服务项目的推广布道和提升开发者应用学习为价值。

通过中国开源软件推进联盟跨越12年的两次开源社区统计分析，我们总结出当今国内开源社区发展有以下特点：

* 中国的门户型社区数量略有下降，两极分化严重，强者愈强，但与全球顶级开源社区相比仍有较大差距。大多数门户型社区正在从资源型向服务型转变，他们具备较强的行业影响力和成熟的商业运营模式，部分领先的门户型社区已经具备与国际知名开源社区和开源基金会对接合作的能力，其中CSDN开发者社区和Gitee社区正在制定全球化发展战略。
* 12年来，中国的项目型社区数量增加但占比依然较少，项目型社区整体发展有起色，得益于具有前瞻性的科技企业推动，其中除少数知名科技企业外，多数项目型社区背后的主导科技企业开源底蕴不足，开源治理和社区运营乏力，因此有部分项目社区试图通过项目捐献等形式融入门户型社区，试图突破发展的瓶颈。

关注这些项目型社区，我们发现其转型分化有三个特点：

* 第一，部分项目型社区正在试图直接选择第三代开源社区（全球开源社区、开源基金会）作为宿主社区，如CNCF基金会下的TiKV项目，Apache基金会下的SkyWalking、Kylin、Pulsar等。这一类走国际路线的项目型社区，可以凝聚更多资源，项目可服务全球市场，最终融入全球领先的第三代社区。但这一整套国际化路线的门槛较高，对语言沟通、开源文化、国际社区规则和管理机制的了解和运用让很多国内开发者望而却步。
* 第二，开源项目坚持由发起公司来主导运营的第二代开源社区，如OpenEuler、Deepin深度操作系统社区、Ubuntu-Kylin等。这一类走自主路线的项目社区最大的挑战来源于如何将企业自主与开放共治的社区基因再平衡，这是社区可以获取外部资源参与的前提条件，此外还需要有专业的开源治理专家和社区运营团队，用企业的管理理念和模式难以玩转社区。
* 第三，开源项目围绕具体的特定技术生态系统来汇集，如阿里的云栖开发者社区，这一类虽有多个项目孵化，但核心技术或产品是由单一公司提供，依然属于第二代开源社区，受发起公司或核心技术企业资助。这一类走生态路线的项目社区需要有足够的资源投入，如果体量不够，这种模式很难走通，毕竟社区内多个项目客观上就在分散关注度和资源，选择这条路线的企业需要有打持久战的准备，否则就应该聚焦于一个项目，集中力量，循序渐进。

中国的用户型社区数量增加，且快速迭代，这些社区规模较小，但互动高效，涉及的技术领域变宽，社区力量分散，生存能力较差。在这些用户型社区中，LUG社区数量基本持平，Linux、UNIX等相关技术论坛社区超半数已经消亡，在新涌现的社区中有几类异常活跃，包括物联网技术社区、人工智能技术社区、Android应用开发社区、新开发语言社区（Go、Ruby、Rust、Kotlin、TS等）。

在开源代码托管平台方面，国内的GitCode、确实（Trustie）、Gitee、木兰开源社区等几家平台正在快速发展，但对于国内开发者和国内项目的覆盖度尚有差距，难以满足国内开发者的需求，中国的开源代码托管平台及社区仍需加大加快建设。

在统计开源社区的过程中，我们发现开源社区对于软件合规的重视程度还不够，且“开源社区”等词语已被过度使用。许多企业近年来纷纷效仿知名科技企业自建所谓的“开源社区”，然而该公司和相关产品既与开源无关，又无开源计划，只在舆论上蹭热点，对开源的理解似是而非。因此这类所谓的“开源社区”暂未收录。

最后，随着国家不断加强对科技自主可控的宏观政策执行、数字化转型迫在眉睫以及开源被写入到十四五规划，各行各业都日益开始重视开源，特别是一批基础性的IT项目陆续开源，形成了一股强大的驱动力，也建议业界高效协同起来，加大开源的布道、加强软件合规的普及和加深对开源社区治理的研究。
 
